/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package teamdev.jxcapture.samples.demo;

import teamdev.jxdesktop.Keyboard;
import teamdev.jxdesktop.PlatformContext;
import teamdev.jxdesktop.win32.shell.TrayIcon;
import teamdev.jxdesktop.win32.shell.TrayMessage;

import javax.swing.*;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;

/**
 * @author Ikryanov Vladimir
 */
public class JxCaptureDemo implements Runnable {
    private TrayIcon trayIcon;
    private InputStream inputStream;

    private Keyboard keyboard = Keyboard.createKeyboard();
    private KeyListener keyboardListener = new KeyListener();
    private ResourceBundle resource = ApplicationSettings.getResourceBundle();

    public void run() {
        ApplicationSettings.getInstance().loadSettings();
        
        if (PlatformContext.isWindows()) {
            String messageTitle = resource.getString("TrayIcon.Message.Title");
            String messageText = resource.getString("TrayIcon.Message.Message");
            String tooltip = resource.getString("TrayIcon.ToolTip.Text");

            TrayPopupMenu popupMenu = new TrayPopupMenu(this);
            trayIcon = new TrayIcon(getTrayIcon());
            trayIcon.setToolTip(tooltip);
            trayIcon.setPopupMenu(popupMenu);
            trayIcon.setVisible(true);
            trayIcon.showMessage(new TrayMessage.Info(messageTitle, messageText));
        } else {
            showApplicationWindow();
        }

        keyboard.addKeyListener(keyboardListener);
    }

    /**
     * If System tray is not supported the method display window with the same functionality.
     */
    private void showApplicationWindow() {
        throw new UnsupportedOperationException("JxCapture Demo window is not supported yet.");
    }

    private teamdev.jxdesktop.win32.gdi.Icon getTrayIcon() {
        URL resource = JxCaptureDemo.class.getResource("resources/images/JxCapture.ico");
        try {
            inputStream = resource.openStream();
            return new teamdev.jxdesktop.win32.gdi.Icon(inputStream);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!canExit()) return;

        ApplicationSettings.getInstance().saveSettings();

        try {
            inputStream.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        trayIcon.setVisible(false);
        trayIcon.dispose();

        keyboard.removeKeyListener(keyboardListener);
        keyboard.dispose();

        System.exit(0);
    }

    private boolean canExit() {
        List activeViewers = CaptureOperations.getInstance().getActiveViewers();
        for (int i = 0; i < activeViewers.size(); i++) {
            ImageViewer activeViewer = (ImageViewer) activeViewers.get(i);
            if (!activeViewer.close()) return false;
        }
        return true;
    }

    private class KeyListener extends KeyAdapter {
        private CaptureOperations operations = CaptureOperations.getInstance();

        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() && e.isShiftDown() && !operations.isBusy()) {
                switch (e.getKeyCode()) {
                    case KeyEvent.VK_A:
                        operations.activeWindowCapture();
                        break;
                    case KeyEvent.VK_W:
                        operations.objectCapture();
                        break;
                    case KeyEvent.VK_R:
                        operations.regionCapture();
                        break;
                    case KeyEvent.VK_F:
                        operations.desktopCapture();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty("javax.swing.adjustPopupLocationToFit", "false");
        SwingUtilities.invokeLater(new JxCaptureDemo());
    }
}
